VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ThisWorkbook"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = True
' Copyright (C) 2007 Stephane Germain <stephane.germain@gmail.com>
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or (at
' your option) any later version.
'
' This program is distributed in the hope that it will be useful, but
' WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

Option Explicit
Option Base 0

Private Const ProgName = "eirt"

Private Sub Workbook_Open()
    On Error Resume Next
    AddIns(ProgName).Installed = False
    UninstallAddIn (ProgName & ".xla")
    If Application.Workbooks.Count = 1 Then
        Application.Quit
    Else
        Me.Close
    End If
End Sub

Private Sub UninstallAddIn(name As String)
    On Error Resume Next
    Dim i As Integer, ok As Boolean
    Const HKEY_CURRENT_USER = &H80000001
    Dim ExcelRegistryKey As String
    Dim WmiRegistry As Object
    Dim result As Boolean
    Dim fullname As String
    ExcelRegistryKey = "Software\Microsoft\Office\" & Application.Version & "\Excel\Add-in Manager"
    Set WmiRegistry = GetObject("winmgmts:\\.\root\default:StdRegProv")
    DoEvents
    With AddIns
        For i = 1 To .Count
            If .Item(i).name = name Then
                .Item(i).Installed = False
                fullname = .Item(i).fullname
                ok = True: Exit For
            End If
        Next i
        If Not ok Then Exit Sub
        SendKeys "{HOME}"
        For i = 1 To .Count
            If .Item(i).name = name Then Exit For
            SendKeys "{DOWN}"
        Next i
        SendKeys "~{ESC}"
        Application.CommandBars.FindControl(ID:=943).Execute
    End With
    
    result = WmiRegistry.DeleteValue(HKEY_CURRENT_USER, ExcelRegistryKey, fullname)
End Sub



