Attribute VB_Name = "modWrapper"
' Copyright (C) 2007 Stephane Germain <stephane.germain@gmail.com>
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or (at
' your option) any later version.
'
' This program is distributed in the hope that it will be useful, but
' WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

Option Explicit
Option Base 0

' functions in the library (see irt_wrapper.c)

#If Win64 Then

Declare ptrsafe Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" _
    (ByVal hwnd As Long, ByVal lpszOp As String, _
     ByVal lpszFile As String, ByVal lpszParams As String, _
     ByVal LpszDir As String, ByVal FsShowCmd As Long) _
     As Long

Public Declare ptrsafe Sub irt_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef patternsPtr As Long, _
ByRef NbrQuad As Long, ByRef QuadFrom As Double, ByRef QuadTo As Double, _
ByRef model As Long, ByRef Penalized As Long, _
ByRef Kernel As Long, ByRef smoothFactor As Double, _
ByRef SlopePrior As Long, ByRef ThreshPrior As Long, ByRef AsympPrior As Long, _
ByRef SlopeMean As Double, ByRef SlopeDev As Double, _
ByRef ThreshMean As Double, ByRef ThreshDev As Double, _
ByRef Asymp_mean As Double, ByRef AsympWeight As Double, _
ByRef MaxEMiter As Long, ByRef MaxNRiter As Long, ByRef Precision As Double, _
ByRef Grouping As Long, _
ByRef slopesPtr As Double, ByRef threshPtr As Double, ByRef asympPtr As Double, _
ByRef slopesSdPtr As Double, ByRef threshSdPtr As Double, ByRef asympSdPtr As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef probsPtr As Double, ByRef probsSdPtr As Double, _
ByRef nbrNotConverge As Long, ByRef notConvergePtr As Long, _
ByRef nbrIgnore As Long, ByRef ignorePtr As Long, ByRef initialized As Long, _
ByRef adjustWeights As Long, ByRef emConverge As Long)

Public Declare ptrsafe Sub eap_abilities_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef abilitiesPtr As Double, ByRef abilitiesSdPtr As Double)

Public Declare ptrsafe Sub mirt_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrOptionTot As Long, _
ByRef itemsPosPtr As Long, ByRef nbrOptionsPtr As Long, _
ByRef patternsPtr As Long, ByRef optionsWeightsPtr As Double, _
ByRef NbrQuad As Long, ByRef QuadFrom As Double, ByRef QuadTo As Double, _
ByRef Penalized As Long, ByRef Kernel As Long, ByRef smoothFactor As Double, _
ByRef Graded As Long, _
ByRef MaxEMiter As Long, ByRef MaxNRiter As Long, ByRef Precision As Double, _
ByRef Grouping As Long, _
ByRef slopesPtr As Double, ByRef threshPtr As Double, _
ByRef slopesSdPtr As Double, ByRef threshSdPtr As Double, _
ByRef slopeinit As Double, ByRef threshInit As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef probsPtr As Double, ByRef probsSdPtr As Double, _
ByRef iccPtr As Double, ByRef iccSdPtr As Double, _
ByRef nbrNotConverge As Long, ByRef notConvergePtr As Long, _
ByRef nbrIgnore As Long, ByRef ignorePtr As Long, ByRef initialized As Long, _
ByRef patternsExpPtr As Long, ByRef adjustWeights As Long, ByRef emConverge As Long)

Public Declare ptrsafe Sub mixed_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrOptionTot As Long, _
ByRef modelsPtr As Long, ByRef methodsPtr As Long, _
ByRef itemsPosPtr As Long, ByRef nbrOptionsPtr As Long, _
ByRef patternsPtr As Long, ByRef optionsWeightsPtr As Double, _
ByRef NbrQuad As Long, ByRef QuadFrom As Double, ByRef QuadTo As Double, _
ByRef smoothFactor As Double, _
ByRef MaxEMiter As Long, ByRef MaxNRiter As Long, ByRef Precision As Double, _
ByRef Grouping As Long, _
ByRef slopesPtr As Double, ByRef threshPtr As Double, _
ByRef slopesSdPtr As Double, ByRef threshSdPtr As Double, _
ByRef slopeinit As Double, ByRef threshInit As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef probsPtr As Double, ByRef probsSdPtr As Double, _
ByRef iccPtr As Double, ByRef iccSdPtr As Double, _
ByRef nbrNotConverge As Long, ByRef notConvergePtr As Long, _
ByRef nbrIgnore As Long, ByRef ignorePtr As Long, ByRef initialized As Long, _
ByRef patternsExpPtr As Long, ByRef emConverge As Long)

Public Declare ptrsafe Sub eap_abilities_mc_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, _
ByRef NbrQuad As Long, ByRef NbrOptionTot As Long, _
ByRef itemsPosPtr As Long, ByRef nbrOptionsPtr As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef abilitiesPtr As Double, ByRef abilitiesSdPtr As Double)

Public Declare ptrsafe Sub info_from_probs_wrapper Lib "eirt64.dll" _
(ByRef NbrItem As Long, ByRef NbrQuad As Long, ByRef probsPtr As Double, _
ByRef quadPointsPtr As Double, ByRef infosPtr As Double, _
ByRef testInfoPtr As Double)

Public Declare ptrsafe Sub info_from_probs_mc_wrapper Lib "eirt64.dll" _
(ByRef NbrItem As Long, ByRef NbrOptionTot As Long, ByRef NbrQuad As Long, _
ByRef probsPtr As Double, ByRef quadPointsPtr As Double, _
ByRef nbrOptionsPtr As Long, ByRef itemsPosPtr As Long, _
ByRef optionsInfosPtr As Double, ByRef infosPtr As Double, _
ByRef testInfoPtr As Double)

Public Declare ptrsafe Sub llk_ratio_fit_test_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef patternsPtr As Long, ByRef quadWeightsPtr As Double, ByRef probsPtr As Double, _
ByRef nbrInter As Long, ByRef chi2Ptr As Double, _
ByRef dfPtr As Long, ByRef pValuePtr As Double)

Public Declare ptrsafe Sub llk_ratio_fit_test_mc_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef NbrOptionTot As Long, ByRef patternsPtr As Long, ByRef quadWeightsPtr As Double, _
ByRef probsPtr As Double, ByRef nbrOptionsPtr As Long, ByRef itemsPosPtr As Long, _
ByRef nbrInter As Long, ByRef chi2Ptr As Double, _
ByRef dfPtr As Long, ByRef pValuePtr As Double)

Public Declare ptrsafe Sub classical_statistics_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef patternsPtr As Long, _
ByRef itemsMeanPtr As Double, ByRef itemsSdPtr As Double, _
ByRef itemsCorrPtr As Double, ByRef itemsPolyCorrPtr As Double, ByRef itemsNbrPtr As Long, _
ByRef subjectsScorePtr As Double, ByRef subjectsNbrPtr As Long, _
ByRef nbr As Long, ByRef mean As Double, ByRef sd As Double, _
ByRef alpha As Double, ByRef pairsCorrPtr As Double)

Public Declare ptrsafe Sub classical_statistics_mc_wrapper Lib "eirt64.dll" _
(ByRef NbrOptionTot As Long, ByRef NbrSubject As Long, ByRef NbrItem As Long, _
ByRef patternsPtr As Long, ByRef optionsWeightsPtr As Double, _
ByRef itemsPosPtr As Long, ByRef nbrOptionsPtr As Long, _
ByRef itemsMeanPtr As Double, ByRef itemsSdPtr As Double, _
ByRef itemsCorrPtr As Double, ByRef itemsPolyCorrPtr As Double, ByRef itemsNbrPtr As Long, _
ByRef subjectsScorePtr As Double, ByRef subjectsNbrPtr As Long, _
ByRef nbr As Long, ByRef mean As Double, ByRef sd As Double, _
ByRef alpha As Double, ByRef pairsCorrPtr As Double)

Public Declare ptrsafe Sub llk_ratio_ld_test_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef chi2Ptr As Double, ByRef dfPtr As Long, ByRef pValuePtr As Double)

Public Declare ptrsafe Sub llk_ratio_ld_test_mc_wrapper Lib "eirt64.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef NbrOptionTot As Long, ByRef patternsPtr As Long, _
ByRef probsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef nbrOptionsPtr As Long, ByRef itemsPosPtr As Long, _
ByRef chi2Ptr As Double, ByRef dfPtr As Long, ByRef pValuePtr As Double)

Public Declare ptrsafe Sub wmle_abilities_wrapper Lib "eirt64.dll" _
(ByRef maxIter As Long, ByRef prec As Double, _
ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, ByRef quadPointsPtr As Double, _
ByRef abilitiesPtr As Double, ByRef abilitiesStddevPtr As Double)
 
 Public Declare ptrsafe Sub wmle_abilities_mc_wrapper Lib "eirt64.dll" _
(ByRef maxIter As Long, ByRef prec As Double, _
ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef NbrOptionTot As Long, ByRef nbrOptionsPtr As Long, ByRef itemsPosPtr As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, ByRef quadPointsPtr As Double, _
ByRef abilitiesPtr As Double, ByRef abilitiesStddevPtr As Double)
                 
 Public Declare ptrsafe Sub continue_on_error Lib "eirt64.dll" (ByRef yes As Long)
                 
#Else

Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" _
    (ByVal hwnd As Long, ByVal lpszOp As String, _
     ByVal lpszFile As String, ByVal lpszParams As String, _
     ByVal LpszDir As String, ByVal FsShowCmd As Long) _
     As Long

Public Declare Sub irt_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef patternsPtr As Long, _
ByRef NbrQuad As Long, ByRef QuadFrom As Double, ByRef QuadTo As Double, _
ByRef model As Long, ByRef Penalized As Long, _
ByRef Kernel As Long, ByRef smoothFactor As Double, _
ByRef SlopePrior As Long, ByRef ThreshPrior As Long, ByRef AsympPrior As Long, _
ByRef SlopeMean As Double, ByRef SlopeDev As Double, _
ByRef ThreshMean As Double, ByRef ThreshDev As Double, _
ByRef Asymp_mean As Double, ByRef AsympWeight As Double, _
ByRef MaxEMiter As Long, ByRef MaxNRiter As Long, ByRef Precision As Double, _
ByRef Grouping As Long, _
ByRef slopesPtr As Double, ByRef threshPtr As Double, ByRef asympPtr As Double, _
ByRef slopesSdPtr As Double, ByRef threshSdPtr As Double, ByRef asympSdPtr As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef probsPtr As Double, ByRef probsSdPtr As Double, _
ByRef nbrNotConverge As Long, ByRef notConvergePtr As Long, _
ByRef nbrIgnore As Long, ByRef ignorePtr As Long, ByRef initialized As Long, _
ByRef adjustWeights As Long, ByRef emConverge As Long)

Public Declare Sub eap_abilities_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef abilitiesPtr As Double, ByRef abilitiesSdPtr As Double)

Public Declare Sub mirt_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrOptionTot As Long, _
ByRef itemsPosPtr As Long, ByRef nbrOptionsPtr As Long, _
ByRef patternsPtr As Long, ByRef optionsWeightsPtr As Double, _
ByRef NbrQuad As Long, ByRef QuadFrom As Double, ByRef QuadTo As Double, _
ByRef Penalized As Long, ByRef Kernel As Long, ByRef smoothFactor As Double, _
ByRef Graded As Long, _
ByRef MaxEMiter As Long, ByRef MaxNRiter As Long, ByRef Precision As Double, _
ByRef Grouping As Long, _
ByRef slopesPtr As Double, ByRef threshPtr As Double, _
ByRef slopesSdPtr As Double, ByRef threshSdPtr As Double, _
ByRef slopeinit As Double, ByRef threshInit As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef probsPtr As Double, ByRef probsSdPtr As Double, _
ByRef iccPtr As Double, ByRef iccSdPtr As Double, _
ByRef nbrNotConverge As Long, ByRef notConvergePtr As Long, _
ByRef nbrIgnore As Long, ByRef ignorePtr As Long, ByRef initialized As Long, _
ByRef patternsExpPtr As Long, ByRef adjustWeights As Long, ByRef emConverge As Long)

Public Declare Sub mixed_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrOptionTot As Long, _
ByRef modelsPtr As Long, ByRef methodsPtr As Long, _
ByRef itemsPosPtr As Long, ByRef nbrOptionsPtr As Long, _
ByRef patternsPtr As Long, ByRef optionsWeightsPtr As Double, _
ByRef NbrQuad As Long, ByRef QuadFrom As Double, ByRef QuadTo As Double, _
ByRef smoothFactor As Double, _
ByRef MaxEMiter As Long, ByRef MaxNRiter As Long, ByRef Precision As Double, _
ByRef Grouping As Long, _
ByRef slopesPtr As Double, ByRef threshPtr As Double, _
ByRef slopesSdPtr As Double, ByRef threshSdPtr As Double, _
ByRef slopeinit As Double, ByRef threshInit As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef probsPtr As Double, ByRef probsSdPtr As Double, _
ByRef iccPtr As Double, ByRef iccSdPtr As Double, _
ByRef nbrNotConverge As Long, ByRef notConvergePtr As Long, _
ByRef nbrIgnore As Long, ByRef ignorePtr As Long, ByRef initialized As Long, _
ByRef patternsExpPtr As Long, ByRef emConverge As Long)

Public Declare Sub eap_abilities_mc_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, _
ByRef NbrQuad As Long, ByRef NbrOptionTot As Long, _
ByRef itemsPosPtr As Long, ByRef nbrOptionsPtr As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, _
ByRef quadPointsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef abilitiesPtr As Double, ByRef abilitiesSdPtr As Double)

Public Declare Sub info_from_probs_wrapper Lib "eirt.dll" _
(ByRef NbrItem As Long, ByRef NbrQuad As Long, ByRef probsPtr As Double, _
ByRef quadPointsPtr As Double, ByRef infosPtr As Double, _
ByRef testInfoPtr As Double)

Public Declare Sub info_from_probs_mc_wrapper Lib "eirt.dll" _
(ByRef NbrItem As Long, ByRef NbrOptionTot As Long, ByRef NbrQuad As Long, _
ByRef probsPtr As Double, ByRef quadPointsPtr As Double, _
ByRef nbrOptionsPtr As Long, ByRef itemsPosPtr As Long, _
ByRef optionsInfosPtr As Double, ByRef infosPtr As Double, _
ByRef testInfoPtr As Double)

Public Declare Sub llk_ratio_fit_test_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef patternsPtr As Long, ByRef quadWeightsPtr As Double, ByRef probsPtr As Double, _
ByRef nbrInter As Long, ByRef chi2Ptr As Double, _
ByRef dfPtr As Long, ByRef pValuePtr As Double)

Public Declare Sub llk_ratio_fit_test_mc_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef NbrOptionTot As Long, ByRef patternsPtr As Long, ByRef quadWeightsPtr As Double, _
ByRef probsPtr As Double, ByRef nbrOptionsPtr As Long, ByRef itemsPosPtr As Long, _
ByRef nbrInter As Long, ByRef chi2Ptr As Double, _
ByRef dfPtr As Long, ByRef pValuePtr As Double)

Public Declare Sub classical_statistics_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef patternsPtr As Long, _
ByRef itemsMeanPtr As Double, ByRef itemsSdPtr As Double, _
ByRef itemsCorrPtr As Double, ByRef itemsPolyCorrPtr As Double, ByRef itemsNbrPtr As Long, _
ByRef subjectsScorePtr As Double, ByRef subjectsNbrPtr As Long, _
ByRef nbr As Long, ByRef mean As Double, ByRef sd As Double, _
ByRef alpha As Double, ByRef pairsCorrPtr As Double)

Public Declare Sub classical_statistics_mc_wrapper Lib "eirt.dll" _
(ByRef NbrOptionTot As Long, ByRef NbrSubject As Long, ByRef NbrItem As Long, _
ByRef patternsPtr As Long, ByRef optionsWeightsPtr As Double, _
ByRef itemsPosPtr As Long, ByRef nbrOptionsPtr As Long, _
ByRef itemsMeanPtr As Double, ByRef itemsSdPtr As Double, _
ByRef itemsCorrPtr As Double, ByRef itemsPolyCorrPtr As Double, ByRef itemsNbrPtr As Long, _
ByRef subjectsScorePtr As Double, ByRef subjectsNbrPtr As Long, _
ByRef nbr As Long, ByRef mean As Double, ByRef sd As Double, _
ByRef alpha As Double, ByRef pairsCorrPtr As Double)

Public Declare Sub llk_ratio_ld_test_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef chi2Ptr As Double, ByRef dfPtr As Long, ByRef pValuePtr As Double)

Public Declare Sub llk_ratio_ld_test_mc_wrapper Lib "eirt.dll" _
(ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef NbrOptionTot As Long, ByRef patternsPtr As Long, _
ByRef probsPtr As Double, ByRef quadWeightsPtr As Double, _
ByRef nbrOptionsPtr As Long, ByRef itemsPosPtr As Long, _
ByRef chi2Ptr As Double, ByRef dfPtr As Long, ByRef pValuePtr As Double)

Public Declare Sub wmle_abilities_wrapper Lib "eirt.dll" _
(ByRef maxIter As Long, ByRef prec As Double, _
ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, ByRef quadPointsPtr As Double, _
ByRef abilitiesPtr As Double, ByRef abilitiesStddevPtr As Double)
 
 Public Declare Sub wmle_abilities_mc_wrapper Lib "eirt.dll" _
(ByRef maxIter As Long, ByRef prec As Double, _
ByRef NbrSubject As Long, ByRef NbrItem As Long, ByRef NbrQuad As Long, _
ByRef NbrOptionTot As Long, ByRef nbrOptionsPtr As Long, ByRef itemsPosPtr As Long, _
ByRef patternsPtr As Long, ByRef probsPtr As Double, ByRef quadPointsPtr As Double, _
ByRef abilitiesPtr As Double, ByRef abilitiesStddevPtr As Double)

 Public Declare Sub continue_on_error Lib "eirt.dll" (ByRef yes As Long)
                 
#End If

